;**************************************
; Test RS485
; Hardware  : CP-PIC V3.0 & V4.0
; OSC       : 10 MHz [HS mode]
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 10/9/2002
;**************************************


     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions


    __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _XT_OSC & _WRT_ENABLE_ON & _LVP_ON & _DEBUG_OFF & _CPD_OFF
#define   DIR  PORTC,5        ; Direction
count1    EQU  0x70
count2    EQU  0x71
temp      EQU  0x72

          ORG       0x0000
          goto      init

          ORG       0x0004
          movlw     0x0f
          movwf     PORTD
          goto      $
          retfie

;************ initial *******************
init      bcf       PORTC,5
          bsf       STATUS,RP0     ; select bank 1
          bcf       TRISC,5        ; Direction control
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG          ;
	  BSF	    TXSTA,BRGH     ; hi speed
          clrf      TRISD          ; PortD output
          bcf       STATUS,RP0     ; select bank 0

          movlw     TXSTA
          movwf     FSR
          bsf       INDF,5

          clrf      RCSTA
          bsf       RCSTA,SPEN      ; Serial port enabled
          bsf       RCSTA,CREN      ; continuous receive
          bcf       DIR
;********** start to receive ************

wait1     btfss     PIR1,RCIF       ; Check RCIF  bit in PIR1 register
          goto      wait1           ; RCREG emty or RCIF = 0
          movf      RCREG,w         ; RCREG full or RCIF = 1
          movwf     temp
          bsf       DIR             ; Dir =  TX
          movf      temp,w
          movwf     TXREG
wait4     movlw     TXSTA           ;
          movwf     FSR             ;
          btfss     INDF,1          ; TSR = empty ?
          goto      wait4           ; NO  (TRMT = 0) ,TSR full
                                    ; Yes (TRMT = 1) ,TSR empty
          call      delay
          call      delay
          bsf       DIR             ; Dir = RX                      
          goto      wait1
;***********************************************
; Delay
;***********************************************
delay     movlw     0xff
          movwf     count1
del2      movlw     0xff
          movwf     count2
del1      decfsz    count2
          goto      del1
          decfsz    count1
          goto      del2
          return

          END
